% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap.R
\name{remap_filtered}
\alias{remap_filtered}
\title{Downloads TF-target interactions from ReMap}
\usage{
remap_filtered(score = 100, top_targets = 500, only_known_tfs = TRUE)
}
\arguments{
\item{score}{Numeric: a minimum score between 0 and 1000, records with
lower scores will be excluded. If NULL no filtering performed.}

\item{top_targets}{Numeric: the number of top scoring targets for each
TF. Essentially the maximum number of targets per TF. If NULL the
number of targets is not restricted.}

\item{only_known_tfs}{Logical: whether to exclude TFs which are not in
TF census.}
}
\value{
Data frame with TF-target relationships.
}
\description{
Downloads the ReMap TF-target interactions as processed by Garcia-Alonso et
al. (\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6673718/#s1title})
and filters them based on a score threshold, the top targets and whether
the TF is included in the TF census (Vaquerizas et al. 2009). The code for
filtering is adapted from DoRothEA, written by Christian Holland.
}
\examples{
\dontrun{
remap_interactions <- remap_filtered()
nrow(remap_interactions)
# [1] 145680

remap_interactions <- remap_filtered(top_targets = 100)
remap_interactions
# # A tibble: 30,330 x 2
#    source_genesymbol target_genesymbol
#    <chr>             <chr>
#  1 ADNP              ABCC1
#  2 ADNP              ABT1
#  3 ADNP              AC006076.1
#  4 ADNP              AC007792.1
#  5 ADNP              AC011288.2
# # . with 30,320 more rows
}

}
\seealso{
\itemize{
    \item{\code{\link{remap_tf_target_download}}}
    \item{\code{\link{remap_filtered}}}
    \item{\code{\link{tfcensus_download}}}
}
}
