% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{uniprot_full_id_mapping_table}
\alias{uniprot_full_id_mapping_table}
\title{Creates an ID translation table from UniProt data}
\usage{
uniprot_full_id_mapping_table(
  to,
  from = "accession",
  reviewed = TRUE,
  organism = 9606
)
}
\arguments{
\item{to}{Character or symbol: target ID type. See Details for possible
values.}

\item{from}{Character or symbol: source ID type. See Details for possible
values.}

\item{reviewed}{Translate only reviewed (\code{TRUE}), only unreviewed
(\code{FALSE}) or both (\code{NULL}) UniProt records.}

\item{organism}{Integer, NCBI Taxonomy ID of the organism (by default
9606 for human).}
}
\value{
A data frame (tibble) with columns `From` and `To`, UniProt IDs
    and the corresponding foreign IDs, respectively.
}
\description{
Creates an ID translation table from UniProt data
}
\details{
For both source and target ID type, this function accepts column codes
used by UniProt and some simple shortcuts defined here. For the UniProt
codes please refer to
https://www.uniprot.org/help/uniprotkb%5Fcolumn%5Fnames
The shortcuts are entrez, genesymbol, genesymbol_syn (synonym gene
symbols), hgnc, embl, refseqp (RefSeq protein), enst (Ensembl transcript),
uniprot_entry (UniProtKB AC, e.g. EGFR_HUMAN), protein_name (full name of
the protein), uniprot (UniProtKB ID, e.g. P00533). For a complete table
please refer to \code{\link{translate_ids}}.
}
\examples{
uniprot_entrez <- uniprot_full_id_mapping_table(to = 'entrez')
uniprot_entrez
# # A tibble: 20,723 x 2
#    From   To
#    <chr>  <chr>
#  1 Q96R72 NA
#  2 Q9UKL2 23538
#  3 Q9H205 144125
#  4 Q8NGN2 219873
#  5 Q8NGC1 390439
# # . with 20,713 more rows

}
\seealso{
\itemize{
    \item{\code{\link{translate_ids}}}
    \item{\code{\link{ensembl_id_mapping_table}}}
    \item{\code{\link{uniprot_id_mapping_table}}}
}
}
