% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterProteins.R
\name{get_proteins_by_value}
\alias{get_proteins_by_value}
\title{Get proteins by value in specific column}
\usage{
get_proteins_by_value(se, column_name = "Reverse", values = c("+"))
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{column_name}{name of column of which proteins with a specific value should be identified}

\item{values}{value of the column defining the proteins that should be identified}
}
\value{
vector of protein IDs
}
\description{
Get proteins by value in specific column
}
\examples{
data(tuberculosis_TMT_se)
proteins <- get_proteins_by_value(tuberculosis_TMT_se,
                      column_name = "Potential.contaminant", values = c("+"))

}
