% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEAnalysis.R
\name{perform_ROTS}
\alias{perform_ROTS}
\title{Performing ROTS}
\usage{
perform_ROTS(
  data,
  condition,
  comparisons,
  condition_name,
  coldata,
  logFC = TRUE,
  logFC_up = 1,
  logFC_down = -1,
  p_adj = TRUE,
  alpha = 0.05,
  B = 100,
  K = 500
)
}
\arguments{
\item{data}{Data table of intensities (rows = proteins, cols = samples)}

\item{condition}{Vector of experimental design specifying the condition(s) to compare}

\item{comparisons}{Vector of comparisons that are performed in the DE analysis (from specify_comparisons method)}

\item{condition_name}{String of name of condition in colData}

\item{coldata}{colData of the SummarizedExperiment}

\item{logFC}{Boolean specifying whether to apply a logFC threshold (TRUE) or not (FALSE)}

\item{logFC_up}{Upper log2 fold change threshold (dividing into up regulated)}

\item{logFC_down}{Lower log2 fold change threshold (dividing into down regulated)}

\item{p_adj}{Boolean specifying whether to apply a threshold on adjusted p-values (TRUE) or on raw p-values (FALSE)}

\item{alpha}{Threshold for adjusted p-values or p-values}

\item{B}{Number of bootstrapping for ROTS}

\item{K}{Number of top-ranked features for reproducibility optimization}
}
\value{
Data table with DE results
}
\description{
Performing ROTS
}
