% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterProteins.R
\name{plot_NA_heatmap}
\alias{plot_NA_heatmap}
\title{Plot heatmap of the NA pattern}
\usage{
plot_NA_heatmap(
  se,
  color_by = NULL,
  label_by = NULL,
  cluster_samples = TRUE,
  cluster_proteins = TRUE,
  show_row_dend = TRUE,
  show_column_dend = FALSE,
  col_vector = NULL
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{color_by}{String specifying the column to color the samples (If NULL, the condition column of the SummarizedExperiment object is used. If "No", no color bar added.)}

\item{label_by}{String specifying the column to label the samples (If NULL, the labels column of the SummarizedExperiment object is used. If "No", no labeling of samples done.)}

\item{cluster_samples}{Boolean. TRUE if samples should be clustered, else FALSE.}

\item{cluster_proteins}{Boolean. TRUE if proteins should be clustered, else FALSE.}

\item{show_row_dend}{Boolean. TRUE if row dendrogram should be shown.}

\item{show_column_dend}{Boolean. TRUE if column dendrogram should be shown.}

\item{col_vector}{Vector of colors for the color bar. If NULL, default colors are used.}
}
\value{
ComplexHeatmap plot (only showing proteins with at least one missing value)
}
\description{
Plot heatmap of the NA pattern
}
\examples{
data(tuberculosis_TMT_se)
plot_NA_heatmap(tuberculosis_TMT_se, color_by = NULL,
                label_by = NULL, cluster_samples = TRUE,
                cluster_proteins = TRUE, show_row_dend = TRUE,
                show_column_dend = FALSE,
                col_vector = NULL)

}
