% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterSamples.R
\name{plot_nr_prot_samples}
\alias{plot_nr_prot_samples}
\title{Plot number of non-zero proteins per sample}
\usage{
plot_nr_prot_samples(se, ain = "raw", color_by = NULL, label_by = NULL)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{ain}{String which data type should be used (default raw)}

\item{color_by}{String specifying the column to color the samples (If NULL, the condition column of the SummarizedExperiment object is used. If "No", no color bar added.)}

\item{label_by}{String specifying the column to label the samples (If NULL, the labels column of the SummarizedExperiment object is used. If "No", no labeling of samples done.)}
}
\value{
ggplot object
}
\description{
Plot number of non-zero proteins per sample
}
\examples{
data(tuberculosis_TMT_se)
plot_nr_prot_samples(tuberculosis_TMT_se, ain="raw", color_by = "Group",
                     label_by = "Label")

}
