% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpikeDEPlots.R
\name{plot_stats_spiked_heatmap}
\alias{plot_stats_spiked_heatmap}
\title{Heatmap of performance metrics for spike-in data sets}
\usage{
plot_stats_spiked_heatmap(
  stats,
  ain = NULL,
  comparisons = NULL,
  metrics = c("Accuracy", "Precision", "F1Score")
)
}
\arguments{
\item{stats}{data table with multiple metrics of the DE results (resulting of get_spiked_stats_DE)}

\item{ain}{Vector of strings of normalization methods to visualize (must be valid normalization methods saved in stats)}

\item{comparisons}{Vector of comparisons (must be valid comparisons saved in stats)}

\item{metrics}{vector of Strings specifying the metrics (must be colnames of stats)}
}
\value{
ggplot object
}
\description{
Heatmap of performance metrics for spike-in data sets
}
\examples{
data(spike_in_se)
data(spike_in_de_res)
stats <- get_spiked_stats_DE(spike_in_se, spike_in_de_res)
plot_stats_spiked_heatmap(stats, ain = NULL, comparisons = NULL,
                          metrics = c("F1Score", "Accuracy"))

}
