% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterSamples.R
\name{remove_POMA_outliers}
\alias{remove_POMA_outliers}
\title{Remove outliers samples detected by the detect_outliers_POMA function}
\usage{
remove_POMA_outliers(se, poma_res_outliers)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{poma_res_outliers}{Outliers data.table returned by the detect_outliers_POMA function}
}
\value{
filtered SummarizedExperiment object
}
\description{
Remove outliers samples detected by the detect_outliers_POMA function
}
\examples{
data(tuberculosis_TMT_se)
poma_res <- detect_outliers_POMA(tuberculosis_TMT_se)
tuberculosis_TMT_se <- remove_POMA_outliers(tuberculosis_TMT_se, poma_res$outliers)

}
