% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterSamples.R
\name{remove_samples_manually}
\alias{remove_samples_manually}
\title{Remove samples with specific value in column manually}
\usage{
remove_samples_manually(se, column, values)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{column}{String specifying the column of the meta data (samples with the specified value in this column will be removed)}

\item{values}{Vector of Strings specifying the value for the removal of samples (samples with this value in the specified column will be removed)}
}
\value{
filtered SummarizedExperiment object
}
\description{
Remove samples with specific value in column manually
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- remove_samples_manually(tuberculosis_TMT_se,
                                column = "Label", values = c("1.HC_Pool1"))

}
