% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browser_ORFikExp.R
\name{multiOmicsPlot_ORFikExp}
\alias{multiOmicsPlot_ORFikExp}
\title{Multi-omics plot using ORFik experiment input}
\usage{
multiOmicsPlot_ORFikExp(
  display_range,
  df,
  annotation = "cds",
  reference_sequence = findFa(df),
  reads = outputLibs(df, type = "pshifted", output.mode = "envirlist", naming = "full",
    BPPARAM = BiocParallel::SerialParam()),
  viewMode = c("tx", "genomic")[1],
  custom_regions = NULL,
  leader_extension = 0,
  trailer_extension = 0,
  withFrames = libraryTypes(df, uniqueTypes = FALSE) \%in\% c("RFP", "RPF", "LSU", "TI"),
  frames_type = "lines",
  colors = NULL,
  kmers = NULL,
  kmers_type = c("mean", "sum")[1],
  ylabels = bamVarName(df),
  lib_to_annotation_proportions = c(0.8, 0.2),
  lib_proportions = NULL,
  annotation_proportions = NULL,
  width = NULL,
  height = NULL,
  plot_name = "default",
  plot_title = NULL,
  display_sequence = c("both", "nt", "aa", "none")[1],
  seq_render_dist = 100,
  aa_letter_code = c("one_letter", "three_letters")[1],
  annotation_names = NULL,
  start_codons = "ATG",
  stop_codons = c("TAA", "TAG", "TGA"),
  custom_motif = NULL,
  log_scale = FALSE,
  BPPARAM = BiocParallel::SerialParam(),
  input_id = "",
  summary_track = FALSE,
  summary_track_type = frames_type,
  export.format = "svg",
  frames_subset = "all"
)
}
\arguments{
\item{display_range}{the whole region to visualize,
a \code{\link[GenomicRanges]{GRangesList}} or \code{\link[GenomicRanges]{GRanges}} object}

\item{df}{an ORFik \code{\link[ORFik]{experiment}} or a list containing ORFik experiments.
Usually a list when you have split Ribo-seq and RNA-seq etc.}

\item{annotation}{the whole annotation which your target region is a subset,
a \code{\link[GenomicRanges]{GRangesList}} or \code{\link[GenomicRanges]{GRanges}} object}

\item{reference_sequence}{the genome reference, default ORFik::findFa(df)}

\item{reads}{the NGS libraries, as a list of \code{\link[GenomicRanges]{GRanges}}
with or without 'score' column for replicates. Can also be a covRle object
of precomputed coverage.
Default: \code{outputLibs(df, type = "pshifted", output.mode = "envirlist",
naming = "full", BPPARAM = BiocParallel::SerialParam())}}

\item{viewMode}{character, default "tx" (transcript coordinates, first position is 1,
exons are merged into a single sequence)\cr
Alternative: "genomic" (genomic coordinates, first position is first position in
\code{display_range} argument. Introns are displayed).}

\item{custom_regions}{a GRangesList or NULL, default: NULL.
The alternative annotation, like self defined uORFs etc. The vertical annotation bars will have
a different color.}

\item{leader_extension}{integer, default 0. (How much to extend view upstream)}

\item{trailer_extension}{integer, default 0. (How much to extend view downstream)}

\item{withFrames}{a logical vector, default
\code{libraryTypes(df, uniqueTypes = FALSE) \%in\% c("RFP", "RPF", "LSU", "TI")}
Alternative: a length 1 or same length as list length of "reads" argument.}

\item{frames_type}{character, default "lines". Alternative:\cr
- columns \cr
- stacks \cr
- area}

\item{colors}{character, default NULL (automatic colouring). If "withFrames" argument
is TRUE, colors are set to to c("red", "green", "blue") for the 3 frames.
Alternative:  Character vector of length 1 or length of "reads" list argument.}

\item{kmers}{numeric (integer), bin positions into kmers. Default NULL, which is equal to 1,
i.e. no binning.}

\item{kmers_type}{character, function used for kmers sliding window. default: "mean", alternative: "sum"}

\item{ylabels}{character, default \code{bamVarName(df)}. Name of libraries in "reads" list argument.}

\item{lib_to_annotation_proportions}{numeric vector of length 2. relative sizes of profiles and annotation.}

\item{lib_proportions}{numeric vector of length equal to displayed libs. Relative sizes of profiles displayed}

\item{annotation_proportions}{numeric vector of length 3 (seq displayed), or 2 (seq not displayed). Relative sizes of annotation tracks.}

\item{width}{numeric, default NULL. Width of plot.}

\item{height}{numeric, default NULL. Height of plot.}

\item{plot_name}{character, default "default" (will create name from display_range name).}

\item{plot_title}{character, default NULL. A title for plot.}

\item{display_sequence}{character/logical, default \code{c("both","nt", "aa", "none")[1]}.
If TRUE or "both", display nucleotide and aa sequence in plot.}

\item{seq_render_dist}{integer, default  100. The sequences will appear after zooming below this threshold.}

\item{aa_letter_code}{character, when set to "three_letters", three letter amino acid code is used. One letter by default.}

\item{annotation_names}{character, default NULL. Alternative naming for annotation.}

\item{start_codons}{character vector, default "ATG"}

\item{stop_codons}{character vector, default c("TAA", "TAG", "TGA")}

\item{custom_motif}{character vector, default NULL.}

\item{log_scale}{logical, default FALSE. Log2 scale the count values, for easier visualization of shapes.}

\item{BPPARAM}{how many cores/threads to use? default: \code{BiocParallel::SerialParam()}.
To see number of threads used for multicores, do \code{BiocParallel::bpparam()$workers}.
You can also add a time remaining bar, for a more detailed pipeline.}

\item{input_id}{character path, default: "", id for shiny to disply structures,
should be "" for local users.}

\item{summary_track}{logical, default FALSE. Display a top track, that is the sum
of all tracks.}

\item{summary_track_type}{character, default is same as 'frames_type'
argument}

\item{export.format}{character, default: "svg". alternative: "png".
when you click the top right image button export, what should it export as?}

\item{frames_subset}{character, default "all". Alternatives: "red", "green", "blue".}
}
\value{
the plot object
}
\description{
Customizable html plots for visualizing genomic data.
}
\examples{
library(RiboCrypt)
df <- ORFik.template.experiment()[9,] #Use third library in experiment only
cds <- loadRegion(df, "cds")
multiOmicsPlot_ORFikExp(extendLeaders(extendTrailers(cds[1], 30), 30), df,
                        frames_type = "columns")
}
