% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVenn.R
\name{SVenn}
\alias{SVenn}
\title{SVenn}
\usage{
SVenn(
  S_list,
  cols.use = NULL,
  opacity = 0.5,
  output_intersectionFile = TRUE,
  filename = "intersection.xlsx"
)
}
\arguments{
\item{S_list}{A list of a maximum of 7 surface protein sets detected in different studies.}

\item{cols.use}{Vector of colors, each color corresponds to a study.
By default, ggplot assigns colors.}

\item{opacity}{Degree of opacity for the colors specified with cols.use (less opacity, more transparency).}

\item{output_intersectionFile}{logical. If TRUE (default) write an xlsx output of protein in the intersections.}

\item{filename}{Name of the output file with the intersections.}
}
\value{
venn plot of common genes.
}
\description{
Venn diagram of common surface proteins overexpressed among up to 7 different studies
}
\examples{
\dontrun{
S_list <- list(SP1 <- c("EPCAM", "CD24",  "DLK1",  "CDCP1", "LYVE1"),
              SP2 <- c("DLK1", "EPCAM", "EGFR", "UPK1A", "UPK2"))
SP <- SVenn(S_list, cols.use = c("pink", "yellow"), output_intersectionFile = FALSE)}
}
\seealso{
\code{\link{Gene2SProtein}} for detection of Surface proteins from a list of genes.

Other plot functions: 
\code{\link{Enrichment_barplot}()},
\code{\link{Splot}()},
\code{\link{plotPCA}()}
}
\concept{plot functions}
