% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callInteractions.R
\name{callInteractions}
\alias{callInteractions}
\title{Call significant interactions}
\usage{
callInteractions(
  umi4c,
  design = ~condition,
  query_regions,
  padj_method = "fdr",
  zscore_threshold = 2,
  padj_threshold = 0.1,
  alpha = 20,
  penalty = 0.1
)
}
\arguments{
\item{umi4c}{UMI4C object as generated by \code{makeUMI4C} or the
\code{UMI4C} constructor.}

\item{design}{A \code{formula} or \code{matrix}. The formula expresses how
the counts for each fragment end depend on the variables in \code{colData}.
See  \code{\link[DESeq2]{DESeqDataSet}}.}

\item{query_regions}{\code{GRanges} object or \code{data.frame} containing
the coordinates of the genomic regions you want to use to perform the
analysis in specific genomic intervals. Default: NULL.}

\item{padj_method}{The method to use for adjusting p-values, see
\code{\link[stats]{p.adjust}}.  Default: fdr.}

\item{zscore_threshold}{Numeric indicating the z-score threshold to
use to define significant differential contacts.  Default: 2.}

\item{padj_threshold}{Numeric indicating the adjusted p-value threshold to
use to define significant differential contacts.  Default: 0.1.}

\item{alpha}{Approximate number of fragments desired for every basis function
of the B-spline basis. \code{floor((max(number of fragments)) / alpha)} is 
passed to \code{create.bspline.basis} as nbasis argument. 4 is the minimum
allowed value. Default: 20.}

\item{penalty}{Amount of smoothing to be applied to the estimated functional 
parameter.  Default: 0.1.}
}
\value{
\code{\link[GenomicRanges]{GRangesList}} where each element is a 
UMI4C sample with the queried regions and their adjusted p-values and Z-scores.
}
\description{
Test a set of \code{query_regions} for significant interactions with the 
viewpoint.
}
\examples{
data("ex_ciita_umi4c")
umi <- ex_ciita_umi4c
win_frags <- makeWindowFragments(umi, n_frags=8, sliding=1)

gr <- callInteractions(umi, ~condition, win_frags, padj_threshold = 0.01, zscore_threshold=2)
inter <- getSignInteractions(gr)
}
