% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeUMI4C.R
\name{getNormalizationMatrix}
\alias{getNormalizationMatrix}
\title{Get normalization matrix}
\usage{
getNormalizationMatrix(
  umi4c,
  norm_bins = 10^(3:6),
  post_smooth_win = 50,
  r_expand = 1.2
)
}
\arguments{
\item{umi4c}{\linkS4class{UMI4C} object as generated by \code{\link{makeUMI4C}}.}

\item{norm_bins}{Numeric vector with the genomic bins to use for
normalization. Default: 1K, 10K, 100K, 1Mb.}

\item{post_smooth_win}{Numeric indicating the smoothing window to use.
Default: 50.}

\item{r_expand}{Numeric indicanting the expansion value for normalization.
Default: 1.2.}
}
\value{
Creates a matrix of normalization factors using as a reference the
profile specified in the \linkS4class{UMI4C} object.
}
\description{
Will return a normalization matrix.
}
