% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callInteractions.R
\name{plotInteractionsUMI4C}
\alias{plotInteractionsUMI4C}
\title{Plot Interactions UMI4C}
\usage{
plotInteractionsUMI4C(
  umi4c,
  gr_interactions,
  grouping = "condition",
  significant = TRUE,
  colors = NULL,
  xlim = NULL,
  ylim = NULL,
  TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene,
  longest = TRUE,
  rel_heights = c(0.25, 0.5, 0.25),
  font_size = 14
)
}
\arguments{
\item{umi4c}{\linkS4class{UMI4C} object as generated by \code{\link{makeUMI4C}}.}

\item{gr_interactions}{GRangesList outputed by \code{\link{callInteractions}}.}

\item{grouping}{Grouping used for the different samples. If none available or 
want to add new groupings, run \code{\link{addGrouping}}.}

\item{significant}{Logical indicating whether to plot only significant interactions
(default: TRUE).}

\item{colors}{Named vector of colors to use for plotting for each group.}

\item{xlim}{Limits for the plot x axis (genomic coordinates).}

\item{ylim}{Limits of the trend y axis.}

\item{TxDb}{TxDb object to use for drawing the genomic annotation.}

\item{longest}{Logical indicating whether to plot only the longest
transcripts for each gene in the gene annotation plot.}

\item{rel_heights}{Numeric vector of length 3 or 4 (if differential plot)
indicating the relative heights of each part of the UMI4C plot.}

\item{font_size}{Base font size to use for the UMI4C plot. Default: 14.}
}
\value{
Combined plot with gene annotation, trend and interaction plot.
}
\description{
Plot the results of \code{\link{callInteractions}} together with the gene
annotation and the trend.
}
