% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree2clusters.R
\name{tree2clusters}
\alias{tree2clusters}
\title{Perform Hierarchical Clustering and tree pruning on a phylogenetic tree}
\usage{
tree2clusters(
  treeStr,
  treeDistances = NULL,
  treeLabels = NULL,
  cutHeight = NULL,
  minClusterSize = 1,
  extra = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{treeStr}{A \code{\link[base]{character} vector} of a
phylogenetic tree in Newick format}

\item{treeDistances}{\code{numeric \link[base]{matrix}} of
distances, that were used to generate the tree.
If NULL, it will be inferred from tree branch lengths.}

\item{treeLabels}{A \code{\link[base]{character} vector}
of tree leaf labels.}

\item{cutHeight}{Define at which height to cut tree.
Default automatically defined.}

\item{minClusterSize}{Minimum size of clusters. Default 1.}

\item{extra}{Boolean whether to use extra parameters
for the \code{\link[dynamicTreeCut]{cutreeDynamic}}.}

\item{verbose}{Logical. If TRUE, enables verbose output from the Java backend.}
}
\value{
\itemize{
    \item \code{\link[base]{character} vector} of the clusters.
    Each row contains data for a cluster, separated by space.
    The id of the cluster,
    the size of the cluster (number of elements)
    and the names of its elements,
    Cluster id 0 contains all the objects not assigned
    to a cluster (singletons).
    Example clusters output :
    \tabular{lllll}{
        0 \tab 3 \tab Sample1 \tab Sample2 \tab Sample3 \cr
        1 \tab 3 \tab Sample4 \tab Sample5 \tab Sample6 \cr
        2 \tab 2 \tab Sample7 \tab Sample8 \tab \cr
        3 \tab 2 \tab Sample9 \tab Sample0\tab \cr
    }
}
}
\description{
The phylogenetic tree is pruned with
\code{\link[dynamicTreeCut]{cutreeDynamic}} to get clusters.
}
\examples{
my.clust <- tree2clusters(
    treeStr = dist2tree(
        inputDist = system.file("extdata", "samples.vcf.dist.gz",
            package = "fastreeR"
        )
    ),
    verbose = TRUE
)
}
\references{
Java implementation:
\url{https://github.com/gkanogiannis/BioInfoJava-Utils}
}
\author{
Anestis Gkanogiannis, \email{anestis@gkanogiannis.com}
}
