% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf2istats.R
\name{vcf2istats}
\alias{vcf2istats}
\title{Calculate various per sample statistics from a VCF file}
\usage{
vcf2istats(inputFile, outputFile = NULL)
}
\arguments{
\item{inputFile}{Input vcf file location (uncompressed or gzip compressed).}

\item{outputFile}{Output samples statistics file location.}
}
\value{
A \code{\link[base]{data.frame}} of sample statistics.
}
\description{
Only biallelic SNPs are considered.
For each sample, the following statistics are calculated :
\itemize{
    \item INDIV : Sample name
    \item N_SITES : Total number of SNPs
    \item N_HET : Number of SNPs with
        heterozygous call (\code{0/1} or \code{0|1}
                        or \code{1/0} or \code{1|0})
    \item N_ALT : Number of SNPs with
        alternate homozygous call (\code{1/1} or \code{1|1})
    \item N_REF : Number of SNPs with
        reference homozygous call (\code{0/0} or \code{0|0})
    \item N_MISS : Number of SNPs with
        missing call (\code{./.} or \code{.|.})
    \item P_HET : Percentage of heterozygous calls
    \item P_ALT : Percentage of alternate homozygous calls
    \item P_REF : Percentage of reference homozygous calls
    \item P_MISS : Percentage of missing calls (missing rate)
}
}
\examples{
my.istats <- vcf2istats(
    inputFile =
        system.file("extdata", "samples.vcf.gz", package = "fastreeR")
)
}
\references{
Java implementation:
\url{https://github.com/gkanogiannis/BioInfoJava-Utils}
}
\author{
Anestis Gkanogiannis, \email{anestis@gkanogiannis.com}
}
