% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{draw_hic_contact_map}
\alias{draw_hic_contact_map}
\title{Create Hi-C contact map}
\usage{
draw_hic_contact_map(
  df,
  idr_cutoff = NULL,
  chromosome = NULL,
  start_coordinate = NULL,
  end_coordinate = NULL,
  title = NULL,
  values_normalized = FALSE,
  log_values = TRUE
)
}
\arguments{
\item{df}{output of \code{\link{estimate_idr2d_hic}}, a data frame with
the following columns:
\tabular{rll}{
  column 1: \tab \code{interaction} \tab character; genomic location of
  interaction block (e.g., \code{"chr1:204940000-204940000"})\cr
  column 2: \tab \code{value} \tab numeric; p-value, FDR, or heuristic used
  to rank the interactions\cr
  column 3: \tab \code{"rep_value"} \tab numeric; value of corresponding
  replicate interaction\cr
  column 4: \tab \code{"rank"} \tab integer; rank of the interaction,
  established by value column, ascending order\cr
  column 5: \tab \code{"rep_rank"} \tab integer; rank of corresponding
  replicate interaction\cr
  column 6: \tab \code{"idr"} \tab integer; IDR of the block and the
  corresponding block in the other replicate
}}

\item{idr_cutoff}{numeric; only show blocks with IDR < \code{idr_cutoff},
shows all blocks by default}

\item{chromosome}{character; chromsome name or list of chromosome names to
be analyzed, e.g., UCSC chromosome 1, \code{"chr1"}, defaults to all
chromosomes (\code{chromosome = NULL})}

\item{start_coordinate}{integer; only show contact map window between
\code{"start_coordinate"} and \code{"end_coordinate"}, by default shows
entire chromosome}

\item{end_coordinate}{integer; only show contact map window between
\code{"start_coordinate"} and \code{"end_coordinate"}, by default shows
entire chromosome}

\item{title}{character; plot title}

\item{values_normalized}{logical; are read counts in value column
raw or normalized? Defaults to \code{FALSE}}

\item{log_values}{logical; log-transform value column? Defaults to
\code{TRUE}}
}
\value{
ggplot2 object; Hi-C contact map
}
\description{
Creates Hi-C contact maps to visualize the results of
\code{\link{estimate_idr2d_hic}}.
}
\examples{
idr_results_df <- estimate_idr2d_hic(idr2d:::hic$rep1_df,
                                     idr2d:::hic$rep2_df)
draw_hic_contact_map(idr_results_df, idr_cutoff = 0.05, chromosome = "chr1")

}
