% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{establish_bijection2d}
\alias{establish_bijection2d}
\title{Finds One-to-One Correspondence between Interactions from Replicate 1
and 2}
\usage{
establish_bijection2d(
  rep1_df,
  rep2_df,
  ambiguity_resolution_method = c("overlap", "midpoint", "value"),
  max_gap = -1L
)
}
\arguments{
\item{rep1_df}{data frame of observations (i.e., genomic interactions) of
replicate 1, with at least the following columns (position of columns
matter, column names are irrelevant):
\tabular{rll}{
  column 1: \tab \code{chr_a} \tab character; genomic location of anchor A -
  chromosome (e.g., \code{"chr3"})\cr
  column 2: \tab \code{start_a} \tab integer; genomic location of anchor A -
  start coordinate\cr
  column 3: \tab \code{end_a} \tab integer; genomic location of anchor A -
  end coordinate\cr
  column 4: \tab \code{chr_b} \tab character; genomic location of anchor B -
  chromosome (e.g., \code{"chr3"})\cr
  column 5: \tab \code{start_b} \tab integer; genomic location of anchor B -
  start coordinate\cr
  column 6: \tab \code{end_b} \tab integer; genomic location of anchor B -
  end coordinate\cr
  column 7: \tab \code{value} \tab numeric; p-value, FDR, or heuristic
  used to rank the interactions
}}

\item{rep2_df}{data frame of observations (i.e., genomic interactions) of
replicate 2, with the following columns (position of columns
matter, column names are irrelevant):
\tabular{rll}{
  column 1: \tab \code{chr_a} \tab character; genomic location of anchor A -
  chromosome (e.g., \code{"chr3"})\cr
  column 2: \tab \code{start_a} \tab integer; genomic location of anchor A -
  start coordinate\cr
  column 3: \tab \code{end_a} \tab integer; genomic location of anchor A -
  end coordinate\cr
  column 4: \tab \code{chr_b} \tab character; genomic location of anchor B -
  chromosome (e.g., \code{"chr3"})\cr
  column 5: \tab \code{start_b} \tab integer; genomic location of anchor B -
  start coordinate\cr
  column 6: \tab \code{end_b} \tab integer; genomic location of anchor B -
  end coordinate\cr
  column 7: \tab \code{value} \tab numeric; p-value, FDR, or heuristic used
  to rank the interactions
}}

\item{ambiguity_resolution_method}{defines how ambiguous assignments
(when one interaction in replicate 1 overlaps with multiple interactions in
replicate 2 or vice versa)
are resolved. Available methods:
\tabular{rl}{
  \code{"value"} \tab interactions are prioritized by ascending or descending
  \code{value} column (see \code{sorting_direction}), e.g., if two
  interactions in replicate 1 overlap with one interaction in replicate 2,
  the interaction from replicate 1 is chosen which has a lower (if
  \code{sorting_direction} is \code{"ascending"}) or higher (if
  \code{"descending"}) value \cr
  \code{"overlap"} \tab the interaction pair is chosen which has the highest
  relative overlap, i.e., overlap in nucleotides of replicate 1 interaction
  anchor A and replicate 2 interaction anchor A,
  plus replicate 1 interaction anchor B and replicate 2 interaction anchor B,
  normalized by their lengths\cr
  \code{"midpoint"} \tab the interaction pair is chosen which has the
  smallest
  distance between their anchor midpoints, i.e., distance from midpoint of
  replicate 1 interaction anchor A to midpoint of
  replicate 2 interaction anchor A, plus distance from midpoint of
  replicate 1 interaction anchor B to midpoint of
  replicate 2 interaction anchor B
}}

\item{max_gap}{integer; maximum gap in nucleotides allowed between two
anchors for them to be considered as overlapping
(defaults to -1, i.e., overlapping anchors)}
}
\value{
Data frames \code{rep1_df} and \code{rep2_df} with
the following columns:
\tabular{rll}{
  column 1: \tab \code{chr_a} \tab character; genomic location of anchor A -
  chromosome (e.g., \code{"chr3"})\cr
  column 2: \tab \code{start_a} \tab integer; genomic location of anchor A -
  start coordinate\cr
  column 3: \tab \code{end_a} \tab integer; genomic location of anchor A -
  end coordinate\cr
  column 4: \tab \code{chr_b} \tab character; genomic location of anchor B -
  chromosome (e.g., \code{"chr3"})\cr
  column 5: \tab \code{start_b} \tab integer; genomic location of anchor B -
  start coordinate\cr
  column 6: \tab \code{end_b} \tab integer; genomic location of anchor B -
  end coordinate\cr
  column 7: \tab \code{value} \tab numeric; p-value, FDR, or heuristic used
  to rank the interactions\cr
  column 8: \tab \code{"rep_value"} \tab numeric; value of corresponding
  replicate interaction. If no corresponding interaction was found,
  \code{rep_value} is set to \code{NA}.\cr
  column 9: \tab \code{"rank"} \tab integer; rank of the interaction,
  established by value column, ascending order\cr
  column 10: \tab \code{"rep_rank"} \tab integer; rank of corresponding
  replicate interaction. If no corresponding interaction was found,
  \code{rep_rank} is set to \code{NA}.\cr
  column 11: \tab \code{"idx"} \tab integer; interaction index,
  primary key\cr
  column 12: \tab \code{"rep_idx"} \tab integer; specifies the index of the
  corresponding interaction in the other replicate (foreign key). If no
  corresponding interaction was found, \code{rep_idx} is set to \code{NA}.
}
}
\description{
This method establishes a bijective assignment between interactions from
replicate 1 and 2. An interaction in replicate 1 is assigned to an
interaction in replicate 2 if and only if (1) both anchors of the
interactions
overlap (or the gap between anchor A/B in replicate 1 and 2 is less than
or equal to \code{max_gap}), and (2) there is no other interaction in
replicate 2 that overlaps with the interaction in replicate 1 and has a
lower \emph{ambiguity resolution value}.
}
\examples{
rep1_df <- idr2d:::chiapet$rep1_df
rep1_df$fdr <- preprocess(rep1_df$fdr, "log_additive_inverse")

rep2_df <- idr2d:::chiapet$rep2_df
rep2_df$fdr <- preprocess(rep2_df$fdr, "log_additive_inverse")

mapping <- establish_bijection2d(rep1_df, rep2_df)

}
