% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hic.R
\name{parse_hic_pro_matrix}
\alias{parse_hic_pro_matrix}
\title{Parse .matrix and .bed files from HiC-Pro for IDR2D analysis}
\usage{
parse_hic_pro_matrix(matrix_file, bed_file, chromosome = "chr1")
}
\arguments{
\item{matrix_file}{path to .matrix file from HiC-Pro analysis run}

\item{bed_file}{path to .bed file from HiC-Pro analysis run}

\item{chromosome}{chromsome name to be analyzed, defaults to
UCSC chromosome 1 (\code{"chr1"})}
}
\value{
Data frame with the following columns:
\tabular{rll}{
  column 1: \tab \code{chr} \tab character; chromosome of block
  (e.g., \code{"chr3"})\cr
  column 2: \tab \code{region1} \tab integer; genomic location of side A of
  block in Hi-C contact matrix\cr
  column 3: \tab \code{region2} \tab integer; genomic location of side B of
  block in Hi-C contact matrix\cr
  column 4: \tab \code{value} \tab numeric; (normalized) read count in block
}
}
\description{
This function is used to convert the contact matrix from a HiC-Pro pipeline
analysis run into an IDR2D compatible format. It takes one .matrix and one
.bed file per replicate from HiC-Pro and returns the contact matrix for a
specific chromosome for IDR2D analysis (see \code{\link{estimate_idr2d_hic}})
}
\references{
Servant, N., Varoquaux, N., Lajoie, B.R. et al. HiC-Pro: an optimized and
flexible pipeline for Hi-C data processing. Genome Biol 16, 259 (2015)
doi:10.1186/s13059-015-0831-x
}
