% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpEffectPlot.R
\name{lmpEffectPlot}
\alias{lmpEffectPlot}
\title{Effect plot}
\usage{
lmpEffectPlot(
  resASCA,
  effectName,
  axes = 1,
  x,
  z = NULL,
  w = NULL,
  hline = 0,
  ...
)
}
\arguments{
\item{resASCA}{A list corresponding to the ASCA output value of \code{\link{lmpPcaEffects}}.}

\item{effectName}{Name of the effect to be used to plot the scores.}

\item{axes}{A numerical vector with the Principal Components axes to be drawn.}

\item{x}{A character string giving the \code{design} factor whose levels will form the x axis.}

\item{z}{A character string giving the \code{design} factor whose levels will form the traces.}

\item{w}{A character string giving the \code{design} factor whose levels will be used for the facet.}

\item{hline}{If not \code{NULL}, draws one or several horizontal line(s) at values given in \code{hline}.}

\item{...}{Additional arguments to be passed to \code{\link{plotMeans}}.}
}
\value{
An effect plot (ggplot).
}
\description{
Plots the ASCA scores by effect levels for a given model effect and for one PC at a time.
This graph is especially appealing to interpret interactions or combined effects.
It is a wrapper of plotMeans.
}
\details{
\code{lmpEffectPlot} is a wrapper of \code{\link{plotMeans}}.
}
\examples{

data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
resLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
resASCA <- lmpPcaEffects(
  resLmpEffectMatrices = resLmpEffectMatrices,
  method = "ASCA", combineEffects = list(c("Hippurate", "Time", "Hippurate:Time"))
)

# Effect plot for an interaction effect
lmpEffectPlot(resASCA, effectName = "Hippurate:Time", x = "Hippurate", z = "Time")
# Effect plot for a combined effect
lmpEffectPlot(resASCA, effectName = "Hippurate+Time+Hippurate:Time", x = "Hippurate", z = "Time")

}
