% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmpScoreScatterPlotM.R
\name{lmpScoreScatterPlotM}
\alias{lmpScoreScatterPlotM}
\title{Scatterplot matrix of effect matrices scores}
\usage{
lmpScoreScatterPlotM(
  resLmpPcaEffects,
  effectNames = NULL,
  PCdim = NULL,
  modelAbbrev = FALSE,
  ...
)
}
\arguments{
\item{resLmpPcaEffects}{A list corresponding to the output value of \code{\link{lmpPcaEffects}}.}

\item{effectNames}{A character vector with the name of the effects to plot.}

\item{PCdim}{A numeric vector with the same length than effectNames and indicating the number of component to plot.}

\item{modelAbbrev}{A logical whether to abbreviate the interaction terms or not.}

\item{...}{Additional arguments to be passed to \code{\link{plotScatterM}}.}
}
\value{
A matrix of graphs
}
\description{
Plots the scores of all model effects simultaneously in a scatterplot matrix.
By default, the first PC only is kept for each model effect and, as a wrapper of \code{\link{plotScatterM}}, the choice of symbols and colors to distinguish factor levels allows an enriched visualization of the factors’ effect on the responses.
}
\details{
\code{lmpScoreScatterPlotM} is a wrapper of \code{\link{plotScatterM}}.
}
\examples{

data("UCH")
resLmpModelMatrix <- lmpModelMatrix(UCH)
ResLmpEffectMatrices <- lmpEffectMatrices(resLmpModelMatrix)
resLmpPcaEffects <- lmpPcaEffects(ResLmpEffectMatrices, method = "ASCA-E")

lmpScoreScatterPlotM(resLmpPcaEffects,
  varname.colorup = "Citrate",
  varname.pchup = "Hippurate",
  varname.pchdown = "Day",
  varname.colordown = "Time"
)

# advanced setting
lmpScoreScatterPlotM(resLmpPcaEffects,
  modelAbbrev = FALSE,
  effectNames = c("Citrate", "Hippurate", "Hippurate:Citrate"),
  PCdim = c(2, 2, 2),
  varname.colorup = "Citrate",
  vec.colorup = c("red", "blue", "green"),
  varname.pchup = "Hippurate",
  vec.pchup = c(1, 2, 3),
  varname.pchdown = "Day",
  vec.pchdown = c(4, 5),
  varname.colordown = "Time",
  vec.colordown = c("brown", "grey")
)

}
