% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceInternalMethods.R
\name{createOutputDir}
\alias{createOutputDir}
\title{Create directories that will contained the results of the
permutations in RDS format}
\usage{
createOutputDir(
  outputDir,
  doingSites = TRUE,
  doingTiles = FALSE,
  saveInfoByGeneration
)
}
\arguments{
\item{outputDir}{a string of \code{character}, the name of the main
directory to be created.}

\item{doingSites}{a \code{logical}, a directory consecrated to contain the
results of the permutation analysis for sites is created when
\code{doingSites} = \code{TRUE}. Default: \code{TRUE}.}

\item{doingTiles}{a \code{logical}, a directory consecrated to contain the
results of the permutation analysis for tiles is created when
\code{doingTiles} = \code{TRUE}. Default: \code{FALSE}.}

\item{saveInfoByGeneration}{a \code{logical}, when \code{TRUE}, the
information about differentially methylated sites and tiles for each
generation is saved in a RDS file. The information is saved in a different
file for each permutation.}
}
\value{
\code{0} when all directories are created without problem.
}
\description{
Create directories that will contained the results of the
permutations in RDS format.
}
\examples{

## Create an output directory for SITES only
methylInheritance:::createOutputDir(outputDir = "testSites",
    doingSites = TRUE, doingTiles = FALSE, saveInfoByGeneration = TRUE)

}
\author{
Astrid Deschenes
}
\keyword{internal}
