% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylInheritanceInternalMethods.R
\name{readInterGenerationResults}
\alias{readInterGenerationResults}
\title{Read and return intergenerational results contained in a
RDS file}
\usage{
readInterGenerationResults(
  outputDir,
  permutationID,
  type = c("sites", "tiles")
)
}
\arguments{
\item{outputDir}{a string of \code{character}, the name of the directory
that will contain
the results of the permutation. The name should end with a slash. The
directory should already exists.}

\item{permutationID}{an \code{integer}, the identifier of the permutation.
When the \code{permutationID} = \code{0}, the results are considered as the
observed results and are saved in a file with the "_observed_results.RDS"
extension. When the \code{permutationID} != \code{0}, the results are
considered as permutation results and are saved in a file with the
"_permutation_permutationID.RDS" extension. Where permutationID is the
identifier of the permutation.}

\item{type}{One of the \code{"sites"} or \code{"tiles"} strings. Specifies
the type of differentially methylated elements should be saved.
Default: \code{"sites"}.}
}
\value{
a \code{list} containing the intergenerational results for the
specified permutation.
}
\description{
Read and return intergenerational results contained in a
RDS file
}
\examples{

## Get the name of the directory where the file is stored
filesDir <- system.file("extdata", "TEST", package="methylInheritance")

## Read DMS intergenerational results for the observed data
methylInheritance:::readInterGenerationResults(outputDir =
    paste0(filesDir, "/"), 0, "sites")

}
\author{
Astrid Deschenes, Pascal Belleau
}
\keyword{internal}
