% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupTips.R
\name{groupTips}
\alias{groupTips}
\alias{groupTips.phyMSAmatched}
\alias{groupTips.lineagePath}
\alias{groupTips.sitesMinEntropy}
\alias{groupTips.fixationSites}
\alias{groupTips.fixationPath}
\title{The grouping of tree tips}
\usage{
groupTips(tree, ...)

\method{groupTips}{phyMSAmatched}(
  tree,
  similarity = NULL,
  simMatrix = NULL,
  forbidTrivial = TRUE,
  tipnames = TRUE,
  ...
)

\method{groupTips}{lineagePath}(tree, tipnames = TRUE, ...)

\method{groupTips}{sitesMinEntropy}(tree, tipnames = TRUE, ...)

\method{groupTips}{fixationSites}(tree, tipnames = TRUE, ...)

\method{groupTips}{fixationPath}(tree, tipnames = TRUE, ...)
}
\arguments{
\item{tree}{The return from \code{\link{addMSA}}, \code{\link{lineagePath}},
\code{\link{sitesMinEntropy}} or other functions.}

\item{...}{Other arguments.}

\item{similarity}{This decides how minor SNPs are to remove. If provided as
fraction between 0 and 1, then the minimum number of SNP will be total tips
times \code{similariy}. If provided as integer greater than 1, the minimum
number will be \code{similariy}. The default \code{similariy} is 0.05 for
\code{lineagePath}.}

\item{simMatrix}{Deprecated and will not have effect.}

\item{forbidTrivial}{Does not allow trivial trimming.}

\item{tipnames}{If return tips as integer or tip names.}
}
\value{
\code{groupTips} returns grouping of tips.
}
\description{
The tips between divergent nodes or fixation mutations on the
  lineages are each gathered as group.
}
\examples{
data(zikv_tree)
data(zikv_align)
tree <- addMSA(zikv_tree, alignment = zikv_align)
groupTips(tree)
}
