% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_motif_by_id}
\alias{get_motif_by_id}
\title{Retrieve motif objects by id}
\usage{
get_motif_by_id(id)
}
\arguments{
\item{id}{character vector of motif identifiers}
}
\value{
A list of objects of class \code{RBPMotif}
}
\description{
Retrieves one or more motif objects identified by motif id.
}
\examples{
get_motif_by_id("M178_0.6")

get_motif_by_id(c("M178_0.6", "M188_0.6"))
}
\seealso{
Other motif functions: 
\code{\link{generate_iupac_by_kmers}()},
\code{\link{generate_iupac_by_matrix}()},
\code{\link{generate_kmers_from_iupac}()},
\code{\link{get_motif_by_rbp}()},
\code{\link{get_motifs}()},
\code{\link{get_motifs_meta_info}()},
\code{\link{get_ppm}()},
\code{\link{init_iupac_lookup_table}()},
\code{\link{set_motifs}()}
}
\concept{motif functions}
