% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum.R
\name{subdivide_data}
\alias{subdivide_data}
\title{Subdivides Sequences into \emph{n} Bins}
\usage{
subdivide_data(sorted_transcript_sequences, n_bins = 40)
}
\arguments{
\item{sorted_transcript_sequences}{character vector of named sequences (names are
usually RefSeq
identifiers and sequence region labels,
 e.g., "NM_1_DUMMY|3UTR"). It is important that the sequences are
 already sorted by fold change,
 signal-to-noise ratio or any other meaningful measure.}

\item{n_bins}{specifies the number of bins in which the sequences
will be divided,
valid values are between 7 and 100}
}
\value{
An array of \code{n_bins} length, containing the binned sequences
}
\description{
Preprocessing function for SPMA, divides transcript sequences
into \emph{n} bins.
}
\examples{
# toy example
toy_seqs <- c(
  "CAACAGCCUUAAUU", "CAGUCAAGACUCC", "CUUUGGGGAAU", "UCAUUUUAUUAAA",
  "AAUUGGUGUCUGGAUACUUCCCUGUACAU", "AUCAAAUUA", "AGAU", "GACACUUAAAGAUCCU",
  "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA", "AUAGAC", "AGUUC", "CCAGUAA"
)
# names are used as keys in the hash table (cached version only)
# ideally sequence identifiers (e.g., RefSeq ids) and
# sequence region labels (e.g., 3UTR for 3'-UTR)
names(toy_seqs) <- c(
  "NM_1_DUMMY|3UTR", "NM_2_DUMMY|3UTR", "NM_3_DUMMY|3UTR",
  "NM_4_DUMMY|3UTR", "NM_5_DUMMY|3UTR", "NM_6_DUMMY|3UTR",
  "NM_7_DUMMY|3UTR",
  "NM_8_DUMMY|3UTR", "NM_9_DUMMY|3UTR", "NM_10_DUMMY|3UTR",
  "NM_11_DUMMY|3UTR",
  "NM_12_DUMMY|3UTR", "NM_13_DUMMY|3UTR", "NM_14_DUMMY|3UTR"
)

foreground_sets <- subdivide_data(toy_seqs, n_bins = 7)

# example data set
background_df <- transite:::ge$background_df
# sort sequences by signal-to-noise ratio
background_df <- dplyr::arrange(background_df, value)
# character vector of named sequences
background_seqs <- background_df$seq
names(background_seqs) <- paste0(background_df$refseq, "|",
  background_df$seq_type)

foreground_sets <- subdivide_data(background_seqs)
}
\seealso{
Other SPMA functions: 
\code{\link{classify_spectrum}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_matrix_spma}()},
\code{\link{score_spectrum}()}
}
\concept{SPMA functions}
