% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-SpectrumScore.R
\docType{class}
\name{SpectrumScore-class}
\alias{SpectrumScore-class}
\alias{.SpectrumScore}
\alias{get_adj_r_squared,SpectrumScore-method}
\alias{get_adj_r_squared}
\alias{get_model_degree,SpectrumScore-method}
\alias{get_model_degree}
\alias{get_model_residuals,SpectrumScore-method}
\alias{get_model_residuals}
\alias{get_model_slope,SpectrumScore-method}
\alias{get_model_slope}
\alias{get_model_f_statistic,SpectrumScore-method}
\alias{get_model_f_statistic}
\alias{get_model_f_statistic_p_value,SpectrumScore-method}
\alias{get_model_f_statistic_p_value}
\alias{get_consistency_score,SpectrumScore-method}
\alias{get_consistency_score}
\alias{get_consistency_score_p_value,SpectrumScore-method}
\alias{get_consistency_score_p_value}
\alias{get_consistency_score_n,SpectrumScore-method}
\alias{get_consistency_score_n}
\alias{show,SpectrumScore-method}
\alias{plot,SpectrumScore,ANY-method}
\alias{plot,SpectrumScore-method}
\title{An S4 class to represent a scored spectrum}
\usage{
get_adj_r_squared(object)

\S4method{get_adj_r_squared}{SpectrumScore}(object)

get_model_degree(object)

\S4method{get_model_degree}{SpectrumScore}(object)

get_model_residuals(object)

\S4method{get_model_residuals}{SpectrumScore}(object)

get_model_slope(object)

\S4method{get_model_slope}{SpectrumScore}(object)

get_model_f_statistic(object)

\S4method{get_model_f_statistic}{SpectrumScore}(object)

get_model_f_statistic_p_value(object)

\S4method{get_model_f_statistic_p_value}{SpectrumScore}(object)

get_consistency_score(object)

\S4method{get_consistency_score}{SpectrumScore}(object)

get_consistency_score_p_value(object)

\S4method{get_consistency_score_p_value}{SpectrumScore}(object)

get_consistency_score_n(object)

\S4method{get_consistency_score_n}{SpectrumScore}(object)

\S4method{show}{SpectrumScore}(object)

\S4method{plot}{SpectrumScore,ANY}(x)
}
\arguments{
\item{object}{SpectrumScore object}

\item{x}{SpectrumScore object}
}
\value{
Object of type SpectrumScore
}
\description{
An S4 class to represent a scored spectrum

Getter Method get_adj_r_squared

Getter Method get_model_degree

Getter Method get_model_residuals

Getter Method get_model_slope

Getter Method get_model_f_statistic

Getter Method get_model_f_statistic_p_value

Getter Method get_consistency_score

Getter Method get_consistency_score_p_value

Getter Method get_consistency_score_n
}
\section{Slots}{

\describe{
\item{\code{adj_r_squared}}{adjusted \eqn{R^2} of polynomial model}

\item{\code{degree}}{degree of polynomial (integer between 0 and 5)}

\item{\code{residuals}}{residuals of the polynomial model}

\item{\code{slope}}{coefficient of the linear term of the polynomial model
(spectrum "direction")}

\item{\code{f_statistic}}{F statistic from the F test used to determine the
degree of the polynomial model}

\item{\code{f_statistic_p_value}}{p-value associated with the F statistic}

\item{\code{consistency_score}}{raw local consistency score of the spectrum}

\item{\code{consistency_score_p_value}}{p-value associated with the local consistency
score}

\item{\code{consistency_score_n}}{number of permutations performed to calculate
p-value of local consistency score (permutations performed before early
stopping criterion reached)}

\item{\code{plot}}{spectrum plot}
}}

\examples{
new("SpectrumScore",
    adj_r_squared = 0,
    degree = 0L,
    residuals = 0,
    slope = 0,
    f_statistic = 0,
    f_statistic_p_value = 1,
    consistency_score = 1,
    consistency_score_p_value = 1,
    consistency_score_n = 1000L,
    plot = NULL
)
}
