% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix-based.R
\name{calculate_motif_enrichment}
\alias{calculate_motif_enrichment}
\title{Binding Site Enrichment Value Calculation}
\usage{
calculate_motif_enrichment(
  foreground_scores_df,
  background_scores_df,
  background_total_sites,
  background_absolute_hits,
  n_transcripts_foreground,
  max_fg_permutations = 1e+06,
  min_fg_permutations = 1000,
  e = 5,
  p_adjust_method = "BH"
)
}
\arguments{
\item{foreground_scores_df}{result of \code{\link{score_transcripts}} on
foreground sequence
set (foreground sequence sets must be a subset of the background
sequence set)}

\item{background_scores_df}{result of \code{\link{score_transcripts}}
on background sequence set}

\item{background_total_sites}{number of potential binding sites per sequence
(returned by \code{\link{score_transcripts}})}

\item{background_absolute_hits}{number of putative binding sites per sequence
(returned by \code{\link{score_transcripts}})}

\item{n_transcripts_foreground}{number of sequences in the foreground set}

\item{max_fg_permutations}{maximum number of foreground permutations
performed in
Monte Carlo test for enrichment score}

\item{min_fg_permutations}{minimum number of foreground permutations
performed in
Monte Carlo test for enrichment score}

\item{e}{integer-valued stop criterion for enrichment score Monte Carlo
test: aborting
permutation process after
observing \code{e} random enrichment values with more extreme values than
the actual
enrichment value}

\item{p_adjust_method}{adjustment of p-values from Monte Carlo tests to
avoid alpha error
 accumulation, see \code{\link[stats]{p.adjust}}}
}
\value{
A data frame with the following columns:
\tabular{rl}{
  \code{motif_id} \tab the motif identifier that is used in the original
  motif library\cr
  \code{motif_rbps} \tab the gene symbol of the RNA-binding protein(s)\cr
  \code{enrichment} \tab binding site enrichment between foreground
  and background sequences \cr
  \code{p_value} \tab unadjusted p-value from Monte Carlo test \cr
  \code{p_value_n} \tab number of Monte Carlo test permutations \cr
  \code{adj_p_value} \tab adjusted p-value from Monte Carlo test
  (usually FDR)
}
}
\description{
This function is used to calculate binding site enrichment / depletion scores
between predefined foreground and background sequence sets. Significance
levels of
enrichment values are obtained by Monte Carlo tests.
}
\examples{
foreground_seqs <- c("CAGUCAAGACUCC", "AAUUGGUGUCUGGAUACUUCCCUGUACAU",
  "AGAU", "CCAGUAA")
background_seqs <- c(foreground_seqs, "CAACAGCCUUAAUU", "CUUUGGGGAAU",
                     "UCAUUUUAUUAAA", "AUCAAAUUA", "GACACUUAAAGAUCCU",
                     "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA",
                     "AUAGAC", "AGUUC")
foreground_scores <- score_transcripts(foreground_seqs, cache = FALSE)
background_scores <- score_transcripts(background_seqs, cache = FALSE)
enrichments_df <- calculate_motif_enrichment(foreground_scores$df,
  background_scores$df,
  background_scores$total_sites, background_scores$absolute_hits,
  length(foreground_seqs),
  max_fg_permutations = 1000
)
}
\seealso{
Other matrix functions: 
\code{\link{run_matrix_spma}()},
\code{\link{run_matrix_tsma}()},
\code{\link{score_transcripts}()},
\code{\link{score_transcripts_single_motif}()}
}
\concept{matrix functions}
