% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{count_homopolymer_corrected_kmers}
\alias{count_homopolymer_corrected_kmers}
\title{Correction for Homopolymeric Stretches}
\usage{
count_homopolymer_corrected_kmers(sequences, k, kmers, is_rna = FALSE)
}
\arguments{
\item{sequences}{character vector of DNA or RNA sequences}

\item{k}{length of \emph{k}-mer, either \code{6} for hexamers or
\code{7} for heptamers}

\item{kmers}{column sums of return value of
\code{Biostrings::oligonucleotideFrequency(sequences)}}

\item{is_rna}{if \code{sequences} are RNA sequences, this
flag needs to be set}
}
\value{
Returns a named numeric vector, where the elements are
\emph{k}-mer counts and the names are \emph{k}-mers.
}
\description{
Counts all non-overlapping instances of \emph{k}-mers in a given set
of sequences.
}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{check_kmers}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_kmers}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
